//
//  GameDetailsDAO.m
//  RoadTripBingo
//
//  Created by Juan Navas Martin on 3/11/14.
//  Copyright (c) 2014 Juan Navas. All rights reserved.
//

#import "GameDetailsDAO.h"
/*
 GAME_DETAILS
    gameID         - INTEGER
    POSITION       - INTEGER
    NAME           - VARCHAR
    DEF_IMAGE_URL  - VARCHAR
    USR_IMAGE_URL  - VARCHAR
    TIMESTAMP      - TEXT
    LATITUDE       - DOUBLE
    LONGITUDE      - DOUBLE
 */
@implementation GameDetailsDAO

- (NSString *) getDbURL{
    NSArray *paths;
    NSString *docsUrl;
    NSString *dbURL;
    
    paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    docsUrl = [paths objectAtIndex:0];
    
    NSFileManager *manager = [NSFileManager defaultManager];
    
    dbURL = [docsUrl stringByAppendingPathComponent:@"RoadTripBingo.sqlite"];
    
    if (![manager fileExistsAtPath:dbURL]) {
        [manager copyItemAtPath:[[[NSBundle mainBundle] resourcePath] stringByAppendingPathComponent:@"RoadTripBingo.sqlite"] toPath:dbURL error:NULL];
    }
    
    return dbURL;
}

- (NSMutableArray *) getCurrentTrafficSigns: (int) gameID {
    NSMutableArray *currentTrafficSigns = [[NSMutableArray alloc]init];
    
    NSString *url = [self getDbURL];
    NSDateFormatter *df = [[NSDateFormatter alloc]init];
    NSString *date;
    char *temp_char;
    [df setDateFormat:@"yyyyMMddHHmmss"];
    
    if (sqlite3_open([url UTF8String], &db) != SQLITE_OK){
        NSLog(@"There is a problem login to Database: %@", url);
    }
    else {
        //NSString *auxSQL = [NSString stringWithFormat:@, gameID];
        
        const char *sqlStatement = "SELECT POSITION, NAME, DEF_IMAGE_URL, USR_IMAGE_URL, TIMESTAMP, LATITUDE, LONGITUDE FROM GAME_DETAILS WHERE GAMEID=?";
        
        sqlite3_stmt *statement;
        
        if (sqlite3_prepare_v2(db, sqlStatement, -1, &statement, NULL) != SQLITE_OK) {
            NSLog(@"Error preparing statement: %s", sqlStatement);
        }
        else{
            
            sqlite3_bind_int(statement, 1, gameID);
            
            while(sqlite3_step(statement) == SQLITE_ROW){
                
                RTBSign *sign = [[RTBSign alloc]init];
                
                sign.gameID = gameID;
                sign.position = sqlite3_column_int(statement, 0);
                
                temp_char = (char *)sqlite3_column_text(statement, 1);
                sign.name = (temp_char == NULL) ? nil : [NSString stringWithUTF8String:temp_char];
                
                temp_char = (char *)sqlite3_column_text(statement, 2);
                sign.defaultImageUrl = (temp_char == NULL) ? nil : [NSString stringWithUTF8String:temp_char];
                
                temp_char = (char *)sqlite3_column_text(statement, 3);
                sign.userImageUrl = (temp_char == NULL) ? nil : [NSString stringWithUTF8String:temp_char];
                
                temp_char = (char *)sqlite3_column_text(statement, 4);
                date = (temp_char == NULL) ? nil : [NSString stringWithUTF8String:temp_char];
                sign.timestamp = [df dateFromString:date];
                sign.latitude = sqlite3_column_double(statement, 5);
                sign.longitude = sqlite3_column_double(statement, 6);
                
                NSLog(@"\n\nSign: %@", sign);
                
                [currentTrafficSigns addObject:sign];
                
            }
        }
        
        sqlite3_finalize(statement);
    }
    sqlite3_close(db);
    
    NSLog(@"Total Games Count: %lu", (unsigned long)[currentTrafficSigns count]);
    
    
    
    return currentTrafficSigns;
}


/*
 GAME_DETAILS
 ID             - INTEGER
 gameID         - INTEGER
 POSITION       - INTEGER
 NAME           - VARCHAR
 DEF_IMAGE_URL  - VARCHAR
 USR_IMAGE_URL  - VARCHAR
 TIMESTAMP      - TEXT
 LATITUDE       - DOUBLE
 LONGITUDE      - DOUBLE
 */

- (void) saveGameDetails:(NSMutableArray *)gameDetails {
    NSString *url = [self getDbURL];
    long code=0;
    NSLog(@"\n\n\n\n");
    
    if((code = sqlite3_open([url UTF8String], &db) != SQLITE_OK)){
        NSLog(@"SAVE GAME DETAILS: There was a problem opening the DB");
    }
    else {
        
        NSDateFormatter *df = [[NSDateFormatter alloc]init];
        [df setDateFormat:@"yyyyMMddHHmmss"];

        const char *sqlStatement;
        sqlite3_stmt *statement;
        NSString *date;
        
        sqlStatement = "INSERT INTO GAME_DETAILS (gameID, POSITION, NAME, DEF_IMAGE_URL, USR_IMAGE_URL, TIMESTAMP, LATITUDE, LONGITUDE) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        if((code = sqlite3_prepare_v2(db, sqlStatement, -1, &statement, NULL)) != SQLITE_OK) {
            NSLog(@"SAVE GAME DETAILS: There was a problem preparing the statement: %s\nCode = %ld", sqlStatement, code);
        }
        else {
            for (RTBSign *sign in gameDetails) {
                
                sqlite3_bind_int(statement, 1, sign.gameID);
                sqlite3_bind_int(statement, 2, sign.position);
                sqlite3_bind_text(statement, 3, [sign.name UTF8String], -1, NULL);
                sqlite3_bind_text(statement, 4, [sign.defaultImageUrl UTF8String], -1, NULL);
                sqlite3_bind_text(statement, 5, [sign.userImageUrl UTF8String], -1, NULL);
                
                date = [df stringFromDate:sign.timestamp];
                sqlite3_bind_text(statement, 6, [date UTF8String], -1, NULL);
                sqlite3_bind_double(statement, 7, sign.latitude);
                sqlite3_bind_double(statement, 8, sign.longitude);
                
                if((code = sqlite3_step(statement)) != SQLITE_DONE) {
                    NSLog(@"SAVE GAME DETAILS: There was a problem executing statement. Error: %ld\nSQL STATEMENT UTF8:%s", code, sqlStatement);
                }
                sqlite3_reset(statement);
            }
            
        }
        sqlite3_finalize(statement);
    }
    sqlite3_close(db);
}

- (void) updateGameDetails:(RTBSign *)sign {
    
    NSString *url = [self getDbURL];
    NSLog(@"\n\n\n\n");
    
    if((sqlite3_open([url UTF8String], &db) != SQLITE_OK)){
        NSLog(@"UPDATE GAME DETAILS: There was a problem opening the DB.\nError: %d", sqlite3_errcode(db));
    }
    else {
        
        NSDateFormatter *df = [[NSDateFormatter alloc]init];
        [df setDateFormat:@"yyyyMMddHHmmss"];
        
        const char *sqlStatement;
        sqlite3_stmt *statement;
        NSString *date;
        
        sqlStatement = "UPDATE GAME_DETAILS SET USR_IMAGE_URL = ?, TIMESTAMP = ?, LATITUDE = ?, LONGITUDE =? WHERE GAMEID = ? AND POSITION = ?";
        if((sqlite3_prepare_v2(db, sqlStatement, -1, &statement, NULL)) != SQLITE_OK) {
            NSLog(@"UPDATE GAME DETAILS: There was a problem preparing the statement: %s\nError = %d", sqlStatement, sqlite3_errcode(db));
        }
        else {
            sqlite3_bind_text(statement, 1, [sign.userImageUrl UTF8String], -1, NULL);
            
            date = [df stringFromDate:sign.timestamp];
            sqlite3_bind_text(statement, 2, [date UTF8String], -1, NULL);
            
            sqlite3_bind_double(statement, 3, sign.latitude);
            sqlite3_bind_double(statement, 4, sign.longitude);
            
            sqlite3_bind_int(statement, 5, sign.gameID);
            sqlite3_bind_int(statement, 6, sign.position);
            
            if((sqlite3_step(statement)) != SQLITE_DONE) {
                NSLog(@"UPDATE GAME DETAILS: There was a problem executing statement. Error: %d\nSQL STATEMENT UTF8:%s", sqlite3_errcode(db), sqlStatement);
            }
            //sqlite3_reset(statement);
        }
        sqlite3_finalize(statement);
    }
    sqlite3_close(db);    
}


//Delete Traffic Signs
- (void) deleteTrafficSigns: (int) gameID {
    
    NSString *url = [self getDbURL];
    
    if (sqlite3_open([url UTF8String], &db) != SQLITE_OK){
        NSLog(@"There is a problem login to Database: %@", url);
    }
    else {
        //NSString *auxSQL = [NSString stringWithFormat:@, gameID];
        
        const char *sqlStatement = "DELETE FROM GAME_DETAILS WHERE GAMEID=?";
        
        sqlite3_stmt *statement;
        
        
        if(sqlite3_prepare_v2(db, sqlStatement, -1, &statement, NULL) != SQLITE_OK){
            NSLog(@"DELETE GAME DETAILS: There was a problem preparing the statement: %s.\nError code: %d", sqlStatement, sqlite3_errcode(db));
        }
        else {
            sqlite3_bind_int(statement, 1, gameID);
            
            if(sqlite3_step(statement) != SQLITE_DONE){
                NSLog(@"DELETE GAME DETAILS: There was a problem executing statement.\n Sql Error Code= %d", sqlite3_errcode(db));
            }
        }
        sqlite3_finalize(statement);
    }
    sqlite3_close(db);
}

@end
